<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('content_entries', function (Blueprint $table) {
            $table->id();

            $table->foreignId('content_type_id')
                ->constrained('content_types')
                ->cascadeOnDelete();

            $table->enum('status', ['draft', 'published'])->default('draft');
            $table->json('data');                           // values (includes localized objects)
            $table->timestamp('published_at')->nullable();

            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            $table->foreignId('updated_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            $table->timestamps();

            $table->index(['content_type_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('content_entries');
    }
};
