<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('content_types', function (Blueprint $table) {
            $table->id();

            $table->string('name');                         // "Homepage Hero"
            $table->string('slug')->unique();               // "homepage-hero"
            $table->boolean('is_single')->default(false);   // single vs collection

            // ✅ multilingual config
            $table->json('locales')->nullable();            // ["en","fr","ar"]
            $table->string('default_locale')->default('en');

            // ✅ schema definition (fields + restrictions)
            $table->json('schema');                         // { fields: [...] }

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('content_types');
    }
};
