<?php

namespace App\Services\Schema;

class SchemaNormalizer
{
    public function normalize(array $schema): array
    {
        $schema = is_array($schema) ? $schema : [];
        $schema['fields'] = array_values($schema['fields'] ?? []);

        foreach ($schema['fields'] as &$f) {
            $f = is_array($f) ? $f : [];

            $f['key'] = trim((string)($f['key'] ?? ''));
            $f['label'] = (string)($f['label'] ?? $f['key']);
            $f['type'] = strtolower((string)($f['type'] ?? 'string'));

            $f['required'] = (bool)($f['required'] ?? false);
            $f['localized'] = (bool)($f['localized'] ?? false);

            // ensure booleans
            if (in_array($f['type'], ['media', 'image'], true)) {
                $f['multiple'] = (bool)($f['multiple'] ?? false);
            }

            if ($f['type'] === 'repeater') {
                $f['fields'] = array_values($f['fields'] ?? []);
                foreach ($f['fields'] as &$sf) {
                    $sf = is_array($sf) ? $sf : [];
                    $sf['key'] = trim((string)($sf['key'] ?? ''));
                    $sf['label'] = (string)($sf['label'] ?? $sf['key']);
                    $sf['type'] = strtolower((string)($sf['type'] ?? 'string'));
                    $sf['required'] = (bool)($sf['required'] ?? false);
                    $sf['localized'] = (bool)($sf['localized'] ?? false);

                    if (in_array($sf['type'], ['media', 'image'], true)) {
                        $sf['multiple'] = (bool)($sf['multiple'] ?? false);
                    }
                }
            }
        }

        // Remove empty keys (important)
        $schema['fields'] = array_values(array_filter($schema['fields'], fn($f) => !empty($f['key'])));

        return $schema;
    }
}
