<?php

namespace App\Services\Media;

use App\Models\Media;
use App\Services\Media\BunnyCDNService;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Str;

class MediaService
{
    public function upload(UploadedFile $file, ?int $userId = null): Media
    {
        $ext = strtolower($file->getClientOriginalExtension() ?: 'bin');
        $name = Str::uuid()->toString() . '.' . $ext;

        // Save on origin (Laravel storage) -> Bunny Pull Zone will serve it
        $path = $file->storeAs('uploads', $name, 'public');

        $bunny = app(BunnyCDNService::class);
        $url = $bunny->cdnUrlForPath($path);

        return Media::create([
            'disk' => 'public',
            'path' => $path,
            'url' => $url,
            'mime' => $file->getMimeType(),
            'size' => $file->getSize(),
            'uploaded_by' => $userId,
        ]);
    }
}
