<?php

namespace App\Services\Content;

use Illuminate\Support\Facades\Cache;

class ContentCache
{
    public function key(string $slug, string $locale, string $fallback): string
    {
        return "public_content:{$slug}:{$locale}:{$fallback}";
    }

    public function forgetAllForSlug(string $slug): void
    {
        // Simple strategy: forget common locales.
        // If you want perfect invalidation, store locale list and loop.
        foreach (['en','fr','ar'] as $loc) {
            Cache::forget($this->key($slug, $loc, 'en'));
            Cache::forget($this->key($slug, $loc, $loc));
        }
    }
}
