<?php

namespace App\Models;

use App\Models\Blog;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Category extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $dates = ['deleted_at'];

    protected $fillable = [
        'name' ,'description' ,'slug' , 'image' ,'featured'
    ];

    public function blogs()
    {
        return $this->hasMany(Blog::class);
    }
     public function subcategories()
    {
        return $this->hasMany(SubCategory::class);
    }
  
}
